'
''Title: mciCommandString Tutorial v1.5 - Example App (DotNet Edition)
'
''By: Jason Hensley
'
''Contact: mailto:jason@vbcodesource.com
'
''Website: http://www.vbcodesource.com or http://www.vbcodesource.info
'
''Description: This is the example application I made to go with the 
'"MCI Tutorial - 'DotNET' Edition" tutorial. This basically puts the code 
'and explanations in the tutorial to life and shows you by example on how to 
'program the Windows 'mciSendString' Command Interface. Hopefully you will
'find the Tutorial and along with this Example useful and helpful. :)
'
''Foreward: I know this example application doesn't look very appealing, but 
'it wasn't meant to. It was only to get the point across.
''
'
Public Class frmMain
    Inherits System.Windows.Forms.Form
    '
    Private Declare Function mciSendString Lib "winmm.dll" Alias _
        "mciSendStringA" (ByVal lpstrCommand As String, ByVal _
            lpstrReturnString As String, ByVal uReturnLength As Integer, _
                ByVal hwndCallback As Integer) As Integer
    '
    Private Declare Function mciGetErrorString Lib "winmm.dll" Alias _
        "mciGetErrorStringA" (ByVal dwError As Integer, ByVal lpstrBuffer _
            As String, ByVal uLength As Integer) As Integer
    '
    'Will hold the file and path to play.
    Dim fileName As String = Nothing
    '
    'Will hold the return value from the mciSendString function.
    Dim retVal As Integer = Nothing
    '
    'Will contain the return data from the lpstrReturnString parameter. It
    'needs to have at least a 128 space buffer.
    Dim returnData As String = Space(128)
    '
    'Will hold the return value form the mciGetErrorString function. This 
    'string also needs a 128 space buffer.
    Dim errorString As String = Space(128)
    '
    'Will contain True or False if our mciGetErrorString was successful at 
    'determining our error returned from the mciSendString function.
    Dim errorSuccess As Boolean
    '
    'This is used to hold the length of the song in MS value. I didn't want
    'the timer to keep having to initiate the device for the length of the
    'song.
    Dim songLengthMS As Integer = Nothing
    '
#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnPlay As System.Windows.Forms.Button
    Friend WithEvents btnStop As System.Windows.Forms.Button
    Friend WithEvents btnPause As System.Windows.Forms.Button
    Friend WithEvents btnOpen As System.Windows.Forms.Button
    Friend WithEvents lblError As System.Windows.Forms.Label
    Friend WithEvents cmdClose As System.Windows.Forms.Button
    Friend WithEvents t As System.Windows.Forms.Timer
    Friend WithEvents lblPosition As System.Windows.Forms.Label
    Friend WithEvents lblFilename As System.Windows.Forms.Label
    Friend WithEvents lblTimeFormat As System.Windows.Forms.Label
    Friend WithEvents lblPlaying As System.Windows.Forms.Label
    Friend WithEvents posChange As System.Windows.Forms.HScrollBar
    Friend WithEvents lblVol As System.Windows.Forms.Label
    Friend WithEvents nVol As System.Windows.Forms.NumericUpDown
    Friend WithEvents btnExit As System.Windows.Forms.Button
    Friend WithEvents chkAuto As System.Windows.Forms.CheckBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.btnPlay = New System.Windows.Forms.Button
        Me.btnStop = New System.Windows.Forms.Button
        Me.btnPause = New System.Windows.Forms.Button
        Me.btnOpen = New System.Windows.Forms.Button
        Me.lblError = New System.Windows.Forms.Label
        Me.cmdClose = New System.Windows.Forms.Button
        Me.t = New System.Windows.Forms.Timer(Me.components)
        Me.lblPosition = New System.Windows.Forms.Label
        Me.lblFilename = New System.Windows.Forms.Label
        Me.lblTimeFormat = New System.Windows.Forms.Label
        Me.lblPlaying = New System.Windows.Forms.Label
        Me.posChange = New System.Windows.Forms.HScrollBar
        Me.lblVol = New System.Windows.Forms.Label
        Me.nVol = New System.Windows.Forms.NumericUpDown
        Me.btnExit = New System.Windows.Forms.Button
        Me.chkAuto = New System.Windows.Forms.CheckBox
        CType(Me.nVol, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'btnPlay
        '
        Me.btnPlay.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPlay.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnPlay.Location = New System.Drawing.Point(8, 152)
        Me.btnPlay.Name = "btnPlay"
        Me.btnPlay.Size = New System.Drawing.Size(72, 23)
        Me.btnPlay.TabIndex = 0
        Me.btnPlay.Text = "Play"
        '
        'btnStop
        '
        Me.btnStop.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnStop.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnStop.Location = New System.Drawing.Point(80, 152)
        Me.btnStop.Name = "btnStop"
        Me.btnStop.Size = New System.Drawing.Size(72, 23)
        Me.btnStop.TabIndex = 1
        Me.btnStop.Text = "Stop"
        '
        'btnPause
        '
        Me.btnPause.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnPause.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnPause.Location = New System.Drawing.Point(152, 152)
        Me.btnPause.Name = "btnPause"
        Me.btnPause.Size = New System.Drawing.Size(72, 23)
        Me.btnPause.TabIndex = 2
        Me.btnPause.Text = "Pause"
        '
        'btnOpen
        '
        Me.btnOpen.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnOpen.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnOpen.Location = New System.Drawing.Point(8, 176)
        Me.btnOpen.Name = "btnOpen"
        Me.btnOpen.Size = New System.Drawing.Size(72, 23)
        Me.btnOpen.TabIndex = 3
        Me.btnOpen.Text = "Open"
        '
        'lblError
        '
        Me.lblError.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblError.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblError.Location = New System.Drawing.Point(8, 208)
        Me.lblError.Name = "lblError"
        Me.lblError.Size = New System.Drawing.Size(216, 40)
        Me.lblError.TabIndex = 4
        Me.lblError.Text = "Command Status: "
        '
        'cmdClose
        '
        Me.cmdClose.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.cmdClose.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdClose.Location = New System.Drawing.Point(80, 176)
        Me.cmdClose.Name = "cmdClose"
        Me.cmdClose.Size = New System.Drawing.Size(72, 23)
        Me.cmdClose.TabIndex = 5
        Me.cmdClose.Text = "Close"
        '
        't
        '
        Me.t.Interval = 1000
        '
        'lblPosition
        '
        Me.lblPosition.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblPosition.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblPosition.Location = New System.Drawing.Point(8, 80)
        Me.lblPosition.Name = "lblPosition"
        Me.lblPosition.Size = New System.Drawing.Size(216, 16)
        Me.lblPosition.TabIndex = 6
        Me.lblPosition.Text = "Position (MS):"
        Me.lblPosition.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lblFilename
        '
        Me.lblFilename.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblFilename.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblFilename.Location = New System.Drawing.Point(8, 8)
        Me.lblFilename.Name = "lblFilename"
        Me.lblFilename.Size = New System.Drawing.Size(216, 40)
        Me.lblFilename.TabIndex = 9
        Me.lblFilename.Text = "Filename:"
        '
        'lblTimeFormat
        '
        Me.lblTimeFormat.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblTimeFormat.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblTimeFormat.Location = New System.Drawing.Point(8, 56)
        Me.lblTimeFormat.Name = "lblTimeFormat"
        Me.lblTimeFormat.Size = New System.Drawing.Size(128, 16)
        Me.lblTimeFormat.TabIndex = 10
        Me.lblTimeFormat.Text = "Time Format: "
        '
        'lblPlaying
        '
        Me.lblPlaying.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
        Me.lblPlaying.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblPlaying.Location = New System.Drawing.Point(144, 56)
        Me.lblPlaying.Name = "lblPlaying"
        Me.lblPlaying.Size = New System.Drawing.Size(80, 16)
        Me.lblPlaying.TabIndex = 11
        Me.lblPlaying.Text = "Playing: False"
        '
        'posChange
        '
        Me.posChange.LargeChange = 1
        Me.posChange.Location = New System.Drawing.Point(8, 96)
        Me.posChange.Maximum = 0
        Me.posChange.Name = "posChange"
        Me.posChange.Size = New System.Drawing.Size(216, 16)
        Me.posChange.TabIndex = 12
        '
        'lblVol
        '
        Me.lblVol.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblVol.Location = New System.Drawing.Point(16, 112)
        Me.lblVol.Name = "lblVol"
        Me.lblVol.Size = New System.Drawing.Size(64, 16)
        Me.lblVol.TabIndex = 14
        Me.lblVol.Text = "Vol: 80%"
        Me.lblVol.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'nVol
        '
        Me.nVol.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.nVol.Increment = New Decimal(New Integer() {5, 0, 0, 0})
        Me.nVol.Location = New System.Drawing.Point(24, 128)
        Me.nVol.Name = "nVol"
        Me.nVol.Size = New System.Drawing.Size(48, 20)
        Me.nVol.TabIndex = 15
        Me.nVol.TextAlign = System.Windows.Forms.HorizontalAlignment.Center
        Me.nVol.Value = New Decimal(New Integer() {80, 0, 0, 0})
        '
        'btnExit
        '
        Me.btnExit.FlatStyle = System.Windows.Forms.FlatStyle.Popup
        Me.btnExit.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.btnExit.Location = New System.Drawing.Point(152, 176)
        Me.btnExit.Name = "btnExit"
        Me.btnExit.Size = New System.Drawing.Size(72, 23)
        Me.btnExit.TabIndex = 7
        Me.btnExit.Text = "Exit"
        '
        'chkAuto
        '
        Me.chkAuto.Checked = True
        Me.chkAuto.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkAuto.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.chkAuto.Location = New System.Drawing.Point(104, 120)
        Me.chkAuto.Name = "chkAuto"
        Me.chkAuto.Size = New System.Drawing.Size(112, 24)
        Me.chkAuto.TabIndex = 16
        Me.chkAuto.Text = "AutoPlay on Load"
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(234, 256)
        Me.Controls.Add(Me.chkAuto)
        Me.Controls.Add(Me.nVol)
        Me.Controls.Add(Me.lblVol)
        Me.Controls.Add(Me.posChange)
        Me.Controls.Add(Me.lblPlaying)
        Me.Controls.Add(Me.lblTimeFormat)
        Me.Controls.Add(Me.lblFilename)
        Me.Controls.Add(Me.btnExit)
        Me.Controls.Add(Me.lblPosition)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.lblError)
        Me.Controls.Add(Me.btnOpen)
        Me.Controls.Add(Me.btnPause)
        Me.Controls.Add(Me.btnStop)
        Me.Controls.Add(Me.btnPlay)
        Me.Font = New System.Drawing.Font("Times New Roman", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow
        Me.MaximizeBox = False
        Me.Name = "frmMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = " MCI Interface Tutorial - Example App"
        CType(Me.nVol, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Function playingStatus() As Boolean
        '
        'Returns 'True' or 'False', depending on whether or not the mci
        'device is currently playing or not.
        '
        retVal = mciSendString("status oursong mode", returnData, 128, 0)

        If returnData.Substring(0, 7) = "playing" Then

            playingStatus = True

        Else

            playingStatus = False

        End If

    End Function

    Private Sub btnPlay_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles btnPlay.Click
        '
        'This will create a new device with the specified filename to play.
        '
        'Make sure the filename variable is not a blank. You can't just ask
        'if the filename exists since you format the path below.
        If fileName = Nothing Then Exit Sub
        '
        'Go ahead and tell the device to close the alias even if one was
        'opened or not. No bad side effect or anything will happen if there
        'wasn't one already opened. It just a precaution I use.
        retVal = mciSendString("close oursong", 0, 0, 0)
        '
        'Open and create a new device with the specified filename using the
        'alias name: oursong.
        retVal = mciSendString("open " & fileName & _
            " type mpegvideo alias oursong", 0, 0, 0)
        '
        'Tell the device to play.
        retVal = mciSendString("play oursong", 0, 0, 0)
        '
        'Check to see what happened on the inside.
        errorSuccess = mciGetErrorString(retVal, errorString, 128)
        '
        'See what is returned by the device.
        lblError.Text = "Error Status: " & errorString

        t.Enabled = True
        '
        'Get the length of the currently opened song in milli-seconds.
        retVal = mciSendString("status oursong length", returnData, 128, 0)
        '
        songLengthMS = Val(returnData)
        '
        'Set the maximun property of the control to the length of the song 
        'so it will accurately set the current position of the device.
        posChange.Maximum = Val(returnData)

    End Sub

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles btnOpen.Click
        '
        'This will open a media file and put the path in the fileName 
        'variable.
        '
        Dim openDLG As OpenFileDialog = New OpenFileDialog

        openDLG.Filter = _
            "Supported Music Files (*.mid, *.mp3, *.wav, *wma)|*.mid;*.mp3;*.wav;*.wma"
        openDLG.Title = "Select the music file to play."

        DialogResult = openDLG.ShowDialog

        If DialogResult = DialogResult.OK Then

            fileName = openDLG.FileName
            '
            'The mciCommandInterface does not like Long filenames unless it 
            'has Quote's("") wrapping the beginning of the path and end of 
            'the path. You can use the getShortFilename function but in my
            'experience, especially in relation to playing on a computer 
            'that will return a network path, the quotes method never fails. 
            'The getShortFilename function did fail at that. :)
            fileName = Chr(34) & fileName & Chr(34)

            lblFilename.Text = "Filename: " & openDLG.FileName
            '
            'If the 'AutoPlay on Load' checkbox is Checked, then hit the
            'play button.
            If chkAuto.Checked Then

                btnPlay.PerformClick()

            End If

        End If

    End Sub

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles cmdClose.Click
        '
        'This closes the device we used. You need to do this EVERYTIME you
        'close your application if you opened a device with your app.
        '
        retVal = mciSendString("close oursong", 0, 0, 0)

        errorSuccess = mciGetErrorString(retVal, errorString, 128)
        lblError.Text = "Error Status: " & errorString

        't.Enabled = False

    End Sub

    Private Sub btnStop_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles btnStop.Click
        '
        'This basically just tells the device to Stop playing.
        '
        retVal = mciSendString("stop oursong", 0, 0, 0)

        't.Enabled = False

        errorSuccess = mciGetErrorString(retVal, errorString, 128)

        lblError.Text = "Error Status: " & errorString

    End Sub

    Private Sub btnPause_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles btnPause.Click
        '
        'This tells the device to 'Pause' or 'Resume', depending on the text
        'of the Pause Button.
        '
        With btnPause

            If .Text = "Pause" Then

                .Text = "Resume"

                retVal = mciSendString("pause oursong", 0, 0, 0)

                't.Enabled = False

                errorSuccess = mciGetErrorString(retVal, errorString, 128)

                lblError.Text = "Error Status: " & errorString

            Else

                .Text = "Pause"

                retVal = mciSendString("resume oursong", 0, 0, 0)

                't.Enabled = True

                errorSuccess = mciGetErrorString(retVal, errorString, 128)

                lblError.Text = "Error Status: " & errorString

            End If

        End With

    End Sub

    Private Sub t_Tick(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles t.Tick
        '
        'Returns our various time related code.
        '
        retVal = mciSendString("status oursong position", returnData, _
            128, 0)

        lblPosition.Text = "Position(ms): " & Val(returnData).ToString & _
            " | Length(ms): " & songLengthMS.ToString
        '
        'Keep the position bar updated in real time to where the song is
        'currently playing.
        posChange.Value = Val(returnData)
        '
        'This will continually keep the label updated with the status of the
        'mci device.
        lblPlaying.Text = "Playing: " & playingStatus.ToString

        retVal = mciSendString("status oursong time format", returnData, _
            128, 0)

        lblTimeFormat.Text = "TimeFormat: " & returnData.ToString

    End Sub

    Private Sub posChange_Scroll(ByVal sender As System.Object, ByVal e As _
        System.Windows.Forms.ScrollEventArgs) Handles posChange.Scroll
        '
        'Will set the current position of the song whether the device is 
        'playing or not.
        '
        If playingStatus() Then
            '
            'The Mci Device is playing so play 'from'.
            retVal = mciSendString("play oursong from " & posChange.Value, _
                0, 0, 0)

        Else
            '
            'The Mci Device is not playing so seek 'to'.
            retVal = mciSendString("seek song to " & posChange.Value, _
                0, 0, 0)

        End If

    End Sub

    Private Sub nVol_ValueChanged(ByVal sender As System.Object, ByVal e _
        As System.EventArgs) Handles nVol.ValueChanged
        '
        'This will change the volume to the value of the numeric control. I
        'made it to where you have to multiply it by 10 to set the correct
        'volume level. This way you don't have to have the control count
        'all the way up to 1000. Only 100 :)
        '
        'But if you want very precise volume levels, then set the maximum 
        'to 1000 instead of 100 and do Not multiply by 10.
        '
        Dim vol As Integer = (nVol.Value * 10)

        retVal = mciSendString("setaudio oursong volume to " & _
           vol, 0, 0, 0)

        lblVol.Text = "Vol: " & (vol / 10) & "%"

    End Sub

    Private Sub frmMain_Closing(ByVal sender As Object, ByVal e As _
        System.ComponentModel.CancelEventArgs) Handles MyBase.Closing

        'remember to do this everytime you close your application.
        retVal = mciSendString("close oursong", 0, 0, 0)

    End Sub

    Private Sub btnExit_Click(ByVal sender As System.Object, ByVal e As _
        System.EventArgs) Handles btnExit.Click

        Me.Close()

    End Sub

End Class